package warlock;

/***
//	Dice is a basic module that knows how to roll dice and to look up
//  results in a table.
//
//	Class members:
//  int     Percent;	// Whole number portion of a percentile die roll.
//  int     Fraction;	// Fractional portion (.00 to .99) of percentile roll.
//
//	Note that a percentile value will be filled in when an instance of the
//  Dice class is created.
***/

public class Dice
{
    int     percent;
    int     fraction;
    
/***
//	public static int rollDie (int MaxValue)
//
//	rollDie () will roll a single multi-sided die and return the result as
//  an integer.  If the die is a 100-sided die, indicated by the passed MaxValue
//  being 100, it will return a number from 0 to 99.  All other types of dice
//  will be numbered from 1 to MaxValue.
***/

    public static int rollDie (int MaxValue)
    {
        int     Gigo;
        
        for (Gigo = (int) (Math.random () * 6); Gigo != 0; Gigo --)
            Math.random ();	// Generate 1-6 random numbers and discard them.
        
        if (MaxValue == 100)
            return (int) (Math.random () * MaxValue);	// Percentile is 00-99.
        else
            return ((int) (Math.random () * MaxValue)) + 1;	// 1-MaxValue.
    }	// roolDie
    
/***
//	public static int rollDice (int Number, int Sides)
//
//	rollDice will roll multiple dice.  You specify how many dice and how
//  many sides each die has.  The total of all the rolls will be returned.
//	Note that 100-sided dice will generate numbers from 0 to 99, so if you
//  ask for multiple 100-sided dice to be rolled, please allow for that.
***/

    public static int rollDice (int Number, int Sides)
    {
        int     DieRoll;
        int     Total = 0;
        
        while (Number != 0)
        {	// Roll dice and total the results.
            DieRoll = rollDie (Sides);
            Total += DieRoll;
            Number --;
        }	// while
        
        return Total;
    }	// rollDice
    
/***
//	public rollPercentile ()
//
//	rollPercentile () will roll a fractional percent to 2 decimal places.
//  You must have created an instance of the Dice class and use this method
//  on that instance.  It will then fill in the Percent class member with the
//  whole number portion of the percentage rolled.  Fraction will be filled in
//  with the fractional portion of the percentage rolled.  Both values will be
//  integers from 0 to 99.  This makes them easy to compare without floating
//  point rounding problems.
***/

    public void rollPercentile ()
    {
        percent = rollDie (100);	// Set the whole number portion.
        fraction = rollDie (100);	// Set the decimal fraction portion.
    }	// rollPercentile
    
    public Dice ()
    {
        rollPercentile ();	// The class instance must be a percentile.
    }	// Default constructor
    
/***
//	public String getPercentile ()
//
//	getPercentile returns a String of 5 characters with ##.## format.
***/

    public String getPercentile ()
    {
//        String  WholeValue;
//        String  FractionValue;
        
        return Integer.toString (percent + 100).substring (1) 
             + "." 
             + Integer.toString (fraction + 100).substring (1)
             + "%";
    }	// getPercentile
    
    public static void main (String args [])
    {
        int  Count = 1;
        int  Total = 0;
        int  Roll;
        int  Loop;
        int  DiceToRoll;
        int  TypeOfDice;
        Dice Percent = new Dice ();
        Dice TotalPercent = new Dice ();
        
        if (args.length == 0)
        {
            System.out.println ("Percent   = " + Percent.getPercentile ());
            Loop = Dice.rollDie (6);
            System.out.println ("Random D6 = " + Loop);
        }	// if
        else  if (args.length != 3)
        {
            System.out.println ("Bad arguments.  Example: java Dice <How many times to roll> <How many dice to roll> <How many sides>");
        }	// else-if
        else
        {
            Loop       = Integer.parseInt (args [0]);
            DiceToRoll = Integer.parseInt (args [1]);
            TypeOfDice = Integer.parseInt (args [2]);
            TotalPercent.percent = 0;
            TotalPercent.fraction = 0;
            while (Loop != 0)
            {
                System.out.print ("Roll #" + Count + ": ");
                if (TypeOfDice != 100)
                {
                    Roll = rollDice (DiceToRoll, TypeOfDice);
                    Total += Roll;
                    System.out.println (Roll);
                }	// if
                else
                {
                    if (Count != 1)
                        Percent.rollPercentile ();	// Roll a new percentile.
                    
                    System.out.println (Percent.getPercentile ());
                    TotalPercent.percent += Percent.percent;
                    TotalPercent.fraction += Percent.fraction;
                    if (TotalPercent.fraction > 99)
                    {	// Carry over into the Percent value.
                        TotalPercent.percent ++;
                        TotalPercent.fraction -= 100;
                    }	// if
                }	// else
                
                Count ++;
                Loop --;
            }	// while
            
            if (TypeOfDice != 100)
                System.out.println ("Average = " + ((double) Total) / Count);
            else
            {
                double  DoubleTotal = (double) TotalPercent.percent;
                
                DoubleTotal += ((double) TotalPercent.fraction) / 100;
                System.out.println ("Average = " + DoubleTotal / Count);
            }	// else
        }	// else
    }	// main method for testing Dice class
}	// Dice class
